/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.InvertMask;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;

public class SSEInvertMaskPeer
extends SSEEffectPeer {
    public SSEInvertMaskPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    protected final InvertMask getEffect() {
        return (InvertMask)super.getEffect();
    }

    private float[] getOffset() {
        float xoff = this.getEffect().getOffsetX();
        float yoff = this.getEffect().getOffsetY();
        float[] offsets = new float[]{xoff, yoff};
        try {
            this.getInputTransform(0).inverseDeltaTransform(offsets, 0, offsets, 0, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        offsets[0] = offsets[0] / (float)this.getInputNativeBounds((int)0).width;
        offsets[1] = offsets[1] / (float)this.getInputNativeBounds((int)0).height;
        return offsets;
    }

    @Override
    public ImageData filter(Effect effect, RenderState rstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        this.setEffect(effect);
        Rectangle dstBounds = this.getResultBounds(transform, outputClip, inputs);
        this.setDestBounds(dstBounds);
        HeapImage src0 = (HeapImage)inputs[0].getTransformedImage(dstBounds);
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getPhysicalWidth();
        int src0h = src0.getPhysicalHeight();
        int src0scan = src0.getScanlineStride();
        int[] baseImg = src0.getPixelArray();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        Rectangle src0InputBounds = inputs[0].getTransformedBounds(dstBounds);
        BaseTransform src0Transform = BaseTransform.IDENTITY_TRANSFORM;
        this.setInputBounds(0, src0InputBounds);
        this.setInputNativeBounds(0, src0Bounds);
        float[] src0Rect = new float[4];
        this.getTextureCoordinates(0, src0Rect, src0InputBounds.x, src0InputBounds.y, src0w, src0h, dstBounds, src0Transform);
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(dstw, dsth));
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        int dstscan = dst.getScanlineStride();
        int[] dstPixels = dst.getPixelArray();
        float[] offset_arr = this.getOffset();
        SSEInvertMaskPeer.filter(dstPixels, 0, 0, dstw, dsth, dstscan, baseImg, src0Rect[0], src0Rect[1], src0Rect[2], src0Rect[3], src0w, src0h, src0scan, offset_arr[0], offset_arr[1]);
        inputs[0].releaseTransformedImage(src0);
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }

    private static native void filter(int[] var0, int var1, int var2, int var3, int var4, int var5, int[] var6, float var7, float var8, float var9, float var10, int var11, int var12, int var13, float var14, float var15);
}

